<?php

namespace Smush\Core\Integrations;

use Smush\Core\Controller;

class W3_Total_Cache_Integration extends Controller {
	public function __construct() {
		$this->register_action( 'wp_smush_post_cache_flush_required', array( $this, 'clear_post_cache' ) );
		$this->register_action( 'wp_smush_home_cache_flush_required', array( $this, 'clear_url_cache' ) );
	}

	public function should_run() {
		return parent::should_run() && function_exists( 'w3tc_flush_post' );
	}

	public function clear_post_cache( $post_id ) {
		if ( function_exists( 'w3tc_flush_post' ) ) {
			w3tc_flush_post( $post_id );
		}
	}

	public function clear_url_cache( $url ) {
		if ( function_exists( 'w3tc_flush_url' ) ) {
			w3tc_flush_url( $url );
		}
	}
}